import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/route/route.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_images.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/data/controller/nominee/nominee_controller.dart';
import 'package:viserpay/data/controller/savings/savings_controller.dart';
import 'package:viserpay/data/model/savings/organaization_list_response_model.dart';
import 'package:viserpay/data/repo/nominee/nominee_repo.dart';
import 'package:viserpay/data/repo/saving/saving_repo.dart';
import 'package:viserpay/data/services/api_service.dart';
import 'package:viserpay/view/components/app-bar/custom_appbar.dart';
import 'package:viserpay/view/components/buttons/gradient_rounded_button.dart';
import 'package:viserpay/view/components/dropdown/generic_drop_down.dart';
import 'package:viserpay/view/components/snack_bar/show_custom_snackbar.dart';
import 'package:viserpay/view/screens/savings/widget/dps_bank_widget.dart';

class SavingOrganizationsScreen extends StatefulWidget {
  const SavingOrganizationsScreen({super.key});

  @override
  State<SavingOrganizationsScreen> createState() => _SavingOrganizationsScreenState();
}

class _SavingOrganizationsScreenState extends State<SavingOrganizationsScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(SavingRepo(apiClient: Get.find()));
    Get.put(NomineeRepo(apiClient: Get.find()));
    Get.put(NomineeController(nomineeRepo: Get.find()));
    Get.put(SavingsController(savingRepo: Get.find(), nomineeController: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {});
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.colorWhite,
      appBar: CustomAppBar(
        title: MyStrings.savings,
        isTitleCenter: true,
        elevation: 0.1,
        action: [
          const SizedBox(width: Dimensions.space20),
        ],
      ),
      body: GetBuilder<SavingsController>(
        builder: (controller) {
          return Padding(
            padding: Dimensions.defaultPaddingHV,
            child: Column(
              children: [
                GenericDropdown<SavingBank>(
                  title: MyStrings.selectOrganization,
                  list: controller.organizationList,
                  onChanged: (value) {
                    if (value != null) {
                      controller.selectOrganization(value);
                    }
                  },
                  displayItem: (item) => item.name ?? "",
                  selectedValue: controller.selectedOrganization,
                ),
                const SizedBox(height: Dimensions.space30),
                if (controller.selectedOrganization?.id == "-1") ...[
                  Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Container(
                          padding: EdgeInsets.all(10),
                          decoration: BoxDecoration(
                            color: MyColor.colorWhite,
                            shape: BoxShape.circle,
                          ),
                          child: Image.asset(MyImages.savings, color: Colors.deepPurple, height: 60, width: 60),
                        ),
                        SizedBox(height: Dimensions.space10),
                        Text(MyStrings.selectSelectAnOrganization.tr, style: semiBoldDefault.copyWith(fontSize: 18)),
                        Text(MyStrings.startSavingsNow, style: lightDefault.copyWith()),
                      ],
                    ),
                  )
                ],
                if (controller.dpsPlanList.isNotEmpty) ...[
                  Expanded(
                    child: ListView.separated(
                      physics: const BouncingScrollPhysics(parent: AlwaysScrollableScrollPhysics()),
                      shrinkWrap: true,
                      itemCount: controller.dpsPlanList.length,
                      separatorBuilder: (context, index) => const SizedBox(height: Dimensions.space15),
                      itemBuilder: (context, index) {
                        final dps = controller.dpsPlanList[index];
                        return InkWell(
                          onTap: () => controller.selectDpsPlan(dps),
                          customBorder: RoundedRectangleBorder(borderRadius: BorderRadius.circular(Dimensions.largeRadius)),
                          child: DpsBankWidget(dps: dps),
                        );
                      },
                    ),
                  )
                ],
              ],
            ),
          );
        },
      ),
      bottomNavigationBar: GetBuilder<SavingsController>(
        builder: (controller) {
          return controller.selectedDpsPlan == null
              ? SizedBox.shrink()
              : Container(
                  margin: EdgeInsets.all(10),
                  child: GradientRoundedButton(
                    text: MyStrings.continue_,
                    press: () {
                      if (controller.selectedDpsPlan == null) {
                        CustomSnackBar.error(errorList: [MyStrings.pleaseSelectASavingsPlan]);
                      } else {
                        Get.toNamed(RouteHelper.nomineeListScreen);
                      }
                    },
                  ),
                );
        },
      ),
    );
  }
}
